<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use app\models\Category;

$this->title = 'Новая заявка';
$categories = Category::find()->all();
$categoryList = ArrayHelper::map($categories, 'id', 'name');
?>

    <h1>Создание заявки</h1>

<?php $form = ActiveForm::begin(['id' => 'create-order-form']); ?>

<?= $form->field($model, 'category_id')->dropDownList($categoryList, [
    'prompt' => 'Выберите категорию',
    'id' => 'category-select',
]) ?>

<?= $form->field($model, 'product_id')->dropDownList([], [
    'prompt' => 'Сначала выберите категорию',
    'id' => 'product-select',
]) ?>

<?= $form->field($model, 'quantity')->textInput(['type' => 'number', 'min' => 1, 'value' => 1]) ?>

<?= $form->field($model, 'delivery_date')->input('date', ['min' => date('Y-m-d', strtotime('+1 day'))]) ?>

<?= $form->field($model, 'delivery_address')->textInput(['maxlength' => true]) ?>

<?= $form->field($model, 'payment_method')->dropDownList([
    'cash' => 'Наличными',
    'transfer' => 'Перевод по номеру телефона',
]) ?>

    <div class="form-group">
        <label>
            <input type="checkbox" id="has-comment"> Пожелания по заказу
        </label>
    </div>

<?= $form->field($model, 'comment')->textarea(['rows' => 3, 'disabled' => true, 'id' => 'comment-field']) ?>

    <div class="form-group">
        <?= Html::submitButton('Отправить', ['class' => 'btn']) ?>
    </div>

<?php ActiveForm::end(); ?>

<?php
// JavaScript для подгрузки товаров и активации поля комментария
$js = <<<JS
$('#category-select').on('change', function() {
    var categoryId = $(this).val();
    if (categoryId) {
        $.post('/site/get-products', {category_id: categoryId}, function(data) {
            var options = '<option value="">Выберите товар</option>';
            $.each(data, function(index, product) {
                options += '<option value="' + product.id + '">' + product.name + '</option>';
            });
            $('#product-select').html(options);
        }, 'json');
    } else {
        $('#product-select').html('<option value="">Сначала выберите категорию</option>');
    }
});

$('#has-comment').on('change', function() {
    $('#comment-field').prop('disabled', !this.checked);
});
JS;
$this->registerJs($js);
?>