<?php
use yii\helpers\Html;
use yii\helpers\Url;
$this->title = 'Мои заявки';
?>

    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h1>Мои заявки</h1>
        <?= Html::a('Создать заявку', ['create-order'], ['class' => 'btn']) ?>
    </div>

<?php if (empty($orders)): ?>
    <p>У вас пока нет заявок.</p>
<?php else: ?>
    <table>
        <thead>
        <tr>
            <th>ID</th>
            <th>Категория</th>
            <th>Товар</th>
            <th>Кол-во</th>
            <th>Дата доставки</th>
            <th>Статус</th>
            <th>Действия</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($orders as $order): ?>
            <tr>
                <td><?= $order->id ?></td>
                <td><?= Html::encode($order->category->name) ?></td>
                <td><?= Html::encode($order->product->name) ?></td>
                <td><?= $order->quantity ?></td>
                <td><?= Yii::$app->formatter->asDate($order->delivery_date, 'dd MMM yyyy') ?></td>
                <td>
                    <?php
                    $statusLabels = [
                        'new' => 'Новая',
                        'accepted' => 'Принят',
                        'completed' => 'Завершён',
                    ];
                    echo $statusLabels[$order->status] ?? $order->status;
                    ?>
                </td>
                <td>
                    <?= Html::a('Подробнее', ['view-order', 'id' => $order->id], ['class' => 'btn', 'style' => 'padding: 6px 16px; font-size: 0.9rem;']) ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>